<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBusListingsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bus_listings
         */
        Schema::create('bus_listings', function ($table) {
            $table->increments('id');
            $table->string('name', 255)->nullable();
            $table->string('source', 255)->nullable();
            $table->integer('available_days')->nullable();
            $table->time('departure_time')->nullable();
            $table->integer('transport_partner')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bus_listings');
    }
}
