<?php

namespace Litecms\BusListing;

use User;

class BusListing
{
    /**
     * $bus_listing object.
     */
    protected $bus_listing;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\BusListing\Interfaces\BusListingRepositoryInterface $bus_listing)
    {
        $this->bus_listing = $bus_listing;
    }

    /**
     * Returns count of bus_listing.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.bus_listing.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->bus_listing->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\BusListingUserCriteria());
        }

        $bus_listing = $this->bus_listing->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('bus_listing::' . $view, compact('bus_listing'))->render();
    }
}
