<?php

namespace Litecms\BusListing\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BusListing\Models\BusListing;

class BusListingPolicy
{

    /**
     * Determine if the given user can view the bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function view(UserPolicy $user, BusListing $bus_listing)
    {
        if ($user->canDo('bus_listing.bus_listing.view') && $user->isAdmin()) {
            return true;
        }

        return $bus_listing->user_id == user_id() && $bus_listing->user_type == user_type();
    }

    /**
     * Determine if the given user can create a bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('bus_listing.bus_listing.create');
    }

    /**
     * Determine if the given user can update the given bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function update(UserPolicy $user, BusListing $bus_listing)
    {
        if ($user->canDo('bus_listing.bus_listing.edit') && $user->isAdmin()) {
            return true;
        }

        return $bus_listing->user_id == user_id() && $bus_listing->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, BusListing $bus_listing)
    {
        return $bus_listing->user_id == user_id() && $bus_listing->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function verify(UserPolicy $user, BusListing $bus_listing)
    {
        if ($user->canDo('bus_listing.bus_listing.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given bus_listing.
     *
     * @param UserPolicy $user
     * @param BusListing $bus_listing
     *
     * @return bool
     */
    public function approve(UserPolicy $user, BusListing $bus_listing)
    {
        if ($user->canDo('bus_listing.bus_listing.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
