<?php

namespace Litecms\BusListing\Providers;

use Illuminate\Support\ServiceProvider;

class BusListingServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'bus_listing');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'bus_listing');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.bus_listing', function ($app) {
            return $this->app->make('Litecms\BusListing\BusListing');
        });

                // Bind BusListing to repository
        $this->app->bind(
            'Litecms\BusListing\Interfaces\BusListingRepositoryInterface',
            \Litecms\BusListing\Repositories\Eloquent\BusListingRepository::class
        );

        $this->app->register(\Litecms\BusListing\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\BusListing\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.bus_listing'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/bus_listing.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/bus_listing')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/bus_listing')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
