<?php

namespace Litecms\BusListing\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BusListingTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BusListing\Models\BusListing $bus_listing)
    {
        return [
            'id'                => $bus_listing->getRouteKey(),
            'key'               => [
                'public'    => $bus_listing->getPublicKey(),
                'route'     => $bus_listing->getRouteKey(),
            ], 
            'name'              => $bus_listing->name,
            'source'            => $bus_listing->source,
            'available_days'    => $bus_listing->available_days,
            'departure_time'    => $bus_listing->departure_time,
            'transport_partner' => $bus_listing->transport_partner,
            'url'               => [
                'public'    => trans_url('bus_listing/'.$bus_listing->getPublicKey()),
                'user'      => guard_url('bus_listing/bus_listing/'.$bus_listing->getRouteKey()),
            ], 
            'status'            => trans('app.'.$bus_listing->status),
            'created_at'        => format_date($bus_listing->created_at),
            'updated_at'        => format_date($bus_listing->updated_at),
        ];
    }
}