<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'buses_list',

    /*
     * Modules.
     */
    'modules'   => ['buses_list'],

    
    'buses_list'       => [
        'model' => [
            'model'                 => \Litecms\BusesList\Models\BusesList::class,
            'table'                 => 'buses_lists',
            'presenter'             => \Litecms\BusesList\Repositories\Presenter\BusesListPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name',  'source',  'destination',  'available_days',  'departure_time',  'reach_time',  'fare',  'seats_number',  'transport_partner',  'bus_category',  'bus_number'],
            'translatables'         => [],
            'upload_folder'         => 'buses_list/buses_list',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'BusesList',
            'module'    => 'BusesList',
        ],

    ],
];
