<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBusesListsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: buses_lists
         */
        Schema::create('buses_lists', function ($table) {
            $table->increments('id');
            $table->string('name', 255)->nullable();
            $table->string('source', 255)->nullable();
            $table->text('destination')->nullable();
            $table->integer('available_days')->nullable();
            $table->time('departure_time')->nullable();
            $table->time('reach_time')->nullable();
            $table->integer('fare')->nullable();
            $table->integer('seats_number')->nullable();
            $table->integer('transport_partner')->nullable();
            $table->integer('bus_category')->nullable();
            $table->integer('bus_number')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('buses_lists');
    }
}
