<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('buses_list::buses_list.name') !!} <small> {!! trans('app.manage') !!} {!! trans('buses_list::buses_list.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('buses_list::buses_list.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='buses_list-buses_list-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('buses_list/buses_list')!!}">{!! trans('buses_list::buses_list.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('buses_list/buses_list?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('buses_list/buses_list?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('buses_list/buses_list/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('buses_list::admin.buses_list.partial.actions')
                    -->
                    @include('buses_list::admin.buses_list.partial.filter')
                    @include('buses_list::admin.buses_list.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="buses_list-buses_list-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="buses_list-buses_list-check-all"></th>
                        <th data-field="name">{!! trans('buses_list::buses_list.label.name')!!}</th>
                    <th data-field="source">{!! trans('buses_list::buses_list.label.source')!!}</th>
                    <th data-field="destination">{!! trans('buses_list::buses_list.label.destination')!!}</th>
                    <th data-field="available_days">{!! trans('buses_list::buses_list.label.available_days')!!}</th>
                    <th data-field="departure_time">{!! trans('buses_list::buses_list.label.departure_time')!!}</th>
                    <th data-field="reach_time">{!! trans('buses_list::buses_list.label.reach_time')!!}</th>
                    <th data-field="fare">{!! trans('buses_list::buses_list.label.fare')!!}</th>
                    <th data-field="seats_number">{!! trans('buses_list::buses_list.label.seats_number')!!}</th>
                    <th data-field="transport_partner">{!! trans('buses_list::buses_list.label.transport_partner')!!}</th>
                    <th data-field="bus_category">{!! trans('buses_list::buses_list.label.bus_category')!!}</th>
                    <th data-field="bus_number">{!! trans('buses_list::buses_list.label.bus_number')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#buses_list-buses_list-entry', '{!!guard_url('buses_list/buses_list/0')!!}');
    oTable = $('#buses_list-buses_list-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('buses_list/buses_list') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'name'},
            {data :'source'},
            {data :'destination'},
            {data :'available_days'},
            {data :'departure_time'},
            {data :'reach_time'},
            {data :'fare'},
            {data :'seats_number'},
            {data :'transport_partner'},
            {data :'bus_category'},
            {data :'bus_number'},
        ],
        "pageLength": 25
    });

    $('#buses_list-buses_list-list tbody').on( 'click', 'tr td:not(:first-child)', function (e) {
        e.preventDefault();

        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#buses_list-buses_list-list').DataTable().row( this ).data();
        $('#buses_list-buses_list-entry').load('{!!guard_url('buses_list/buses_list')!!}' + '/' + d.id);
    });

    $('#buses_list-buses_list-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#buses_list-buses_list-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#buses_list-buses_list-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#buses_list-buses_list-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>