<?php

namespace Litecms\BusesList;

use User;

class BusesList
{
    /**
     * $buses_list object.
     */
    protected $buses_list;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\BusesList\Interfaces\BusesListRepositoryInterface $buses_list)
    {
        $this->buses_list = $buses_list;
    }

    /**
     * Returns count of buses_list.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.buses_list.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->buses_list->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\BusesListUserCriteria());
        }

        $buses_list = $this->buses_list->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('buses_list::' . $view, compact('buses_list'))->render();
    }
}
