<?php

namespace Litecms\BusesList\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\BusesList\Http\Requests\BusesListRequest;
use Litecms\BusesList\Interfaces\BusesListRepositoryInterface;
use Litecms\BusesList\Models\BusesList;

/**
 * Resource controller class for buses_list.
 */
class BusesListResourceController extends BaseController
{

    /**
     * Initialize buses_list resource controller.
     *
     * @param type BusesListRepositoryInterface $buses_list
     *
     * @return null
     */
    public function __construct(BusesListRepositoryInterface $buses_list)
    {
        parent::__construct();
        $this->repository = $buses_list;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\BusesList\Repositories\Criteria\BusesListResourceCriteria::class);
    }

    /**
     * Display a list of buses_list.
     *
     * @return Response
     */
    public function index(BusesListRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\BusesList\Repositories\Presenter\BusesListPresenter::class)
                ->$function();
        }

        $buses_lists = $this->repository->paginate();

        return $this->response->title(trans('buses_list::buses_list.names'))
            ->view('buses_list::buses_list.index', true)
            ->data(compact('buses_lists'))
            ->output();
    }

    /**
     * Display buses_list.
     *
     * @param Request $request
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function show(BusesListRequest $request, BusesList $buses_list)
    {

        if ($buses_list->exists) {
            $view = 'buses_list::buses_list.show';
        } else {
            $view = 'buses_list::buses_list.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('buses_list::buses_list.name'))
            ->data(compact('buses_list'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new buses_list.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(BusesListRequest $request)
    {

        $buses_list = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('buses_list::buses_list.name')) 
            ->view('buses_list::buses_list.create', true) 
            ->data(compact('buses_list'))
            ->output();
    }

    /**
     * Create new buses_list.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(BusesListRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $buses_list                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('buses_list::buses_list.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('buses_list/buses_list/' . $buses_list->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/buses_list/buses_list'))
                ->redirect();
        }

    }

    /**
     * Show buses_list for editing.
     *
     * @param Request $request
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function edit(BusesListRequest $request, BusesList $buses_list)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('buses_list::buses_list.name'))
            ->view('buses_list::buses_list.edit', true)
            ->data(compact('buses_list'))
            ->output();
    }

    /**
     * Update the buses_list.
     *
     * @param Request $request
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function update(BusesListRequest $request, BusesList $buses_list)
    {
        try {
            $attributes = $request->all();

            $buses_list->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('buses_list::buses_list.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('buses_list/buses_list/' . $buses_list->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('buses_list/buses_list/' . $buses_list->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the buses_list.
     *
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function destroy(BusesListRequest $request, BusesList $buses_list)
    {
        try {

            $buses_list->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('buses_list::buses_list.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('buses_list/buses_list/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('buses_list/buses_list/' . $buses_list->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple buses_list.
     *
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function delete(BusesListRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('buses_list::buses_list.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('buses_list/buses_list'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/buses_list/buses_list'))
                ->redirect();
        }

    }

    /**
     * Restore deleted buses_lists.
     *
     * @param Model   $buses_list
     *
     * @return Response
     */
    public function restore(BusesListRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('buses_list::buses_list.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/buses_list/buses_list'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/buses_list/buses_list/'))
                ->redirect();
        }

    }

}
