<?php

namespace Litecms\BusesList\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BusesList\Models\BusesList;

class BusesListPolicy
{

    /**
     * Determine if the given user can view the buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function view(UserPolicy $user, BusesList $buses_list)
    {
        if ($user->canDo('buses_list.buses_list.view') && $user->isAdmin()) {
            return true;
        }

        return $buses_list->user_id == user_id() && $buses_list->user_type == user_type();
    }

    /**
     * Determine if the given user can create a buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('buses_list.buses_list.create');
    }

    /**
     * Determine if the given user can update the given buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function update(UserPolicy $user, BusesList $buses_list)
    {
        if ($user->canDo('buses_list.buses_list.edit') && $user->isAdmin()) {
            return true;
        }

        return $buses_list->user_id == user_id() && $buses_list->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, BusesList $buses_list)
    {
        return $buses_list->user_id == user_id() && $buses_list->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function verify(UserPolicy $user, BusesList $buses_list)
    {
        if ($user->canDo('buses_list.buses_list.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given buses_list.
     *
     * @param UserPolicy $user
     * @param BusesList $buses_list
     *
     * @return bool
     */
    public function approve(UserPolicy $user, BusesList $buses_list)
    {
        if ($user->canDo('buses_list.buses_list.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
