<?php

namespace Litecms\BusesList\Providers;

use Illuminate\Support\ServiceProvider;

class BusesListServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'buses_list');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'buses_list');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.buses_list', function ($app) {
            return $this->app->make('Litecms\BusesList\BusesList');
        });

                // Bind BusesList to repository
        $this->app->bind(
            'Litecms\BusesList\Interfaces\BusesListRepositoryInterface',
            \Litecms\BusesList\Repositories\Eloquent\BusesListRepository::class
        );

        $this->app->register(\Litecms\BusesList\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\BusesList\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.buses_list'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/buses_list.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/buses_list')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/buses_list')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
