<?php

namespace Litecms\BusesList\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BusesListTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BusesList\Models\BusesList $buses_list)
    {
        return [
            'id'                => $buses_list->getRouteKey(),
            'key'               => [
                'public'    => $buses_list->getPublicKey(),
                'route'     => $buses_list->getRouteKey(),
            ], 
            'name'              => $buses_list->name,
            'source'            => $buses_list->source,
            'destination'       => $buses_list->destination,
            'available_days'    => $buses_list->available_days,
            'departure_time'    => $buses_list->departure_time,
            'reach_time'        => $buses_list->reach_time,
            'fare'              => $buses_list->fare,
            'seats_number'      => $buses_list->seats_number,
            'transport_partner' => $buses_list->transport_partner,
            'bus_category'      => $buses_list->bus_category,
            'bus_number'        => $buses_list->bus_number,
            'url'               => [
                'public'    => trans_url('buses_list/'.$buses_list->getPublicKey()),
                'user'      => guard_url('buses_list/buses_list/'.$buses_list->getRouteKey()),
            ], 
            'status'            => trans('app.'.$buses_list->status),
            'created_at'        => format_date($buses_list->created_at),
            'updated_at'        => format_date($buses_list->updated_at),
        ];
    }
}