<?php

namespace Litecms\BuyAd;

use User;

class BuyAd
{
    /**
     * $buyads object.
     */
    protected $buyads;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\BuyAd\Interfaces\BuyadsRepositoryInterface $buyads)
    {
        $this->buyads = $buyads;
    }

    /**
     * Returns count of buy_ad.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.buyads.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->buyads->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\BuyadsUserCriteria());
        }

        $buyads = $this->buyads->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('buy_ad::' . $view, compact('buyads'))->render();
    }
}
