<?php

namespace Litecms\BuyAd\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\BuyAd\Interfaces\BuyadsRepositoryInterface;

class BuyadsPublicController extends BaseController
{
    // use BuyadsWorkflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\Buyads\Interfaces\BuyadsRepositoryInterface $buyads
     *
     * @return type
     */
    public function __construct(BuyadsRepositoryInterface $buyads)
    {
        $this->repository = $buyads;
        parent::__construct();
    }

    /**
     * Show buyads's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $buyads = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$buy_ad::$buyads.names'))
            ->view('$buy_ad::public.buyads.index')
            ->data(compact('$buyads'))
            ->output();
    }

    /**
     * Show buyads's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $buyads = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$buy_ad::$buyads.names'))
            ->view('$buy_ad::public.buyads.index')
            ->data(compact('$buyads'))
            ->output();
    }

    /**
     * Show buyads.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $buyads = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$buyads->name . trans('$buy_ad::$buyads.name'))
            ->view('$buy_ad::public.buyads.show')
            ->data(compact('$buyads'))
            ->output();
    }

}
