<?php

namespace Litecms\BuyAd\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\BuyAd\Models\Buyads;

class BuyadsPolicy
{

    /**
     * Determine if the given user can view the buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function view(UserPolicy $user, Buyads $buyads)
    {
        if ($user->canDo('buy_ad.buyads.view') && $user->isAdmin()) {
            return true;
        }

        return $buyads->user_id == user_id() && $buyads->user_type == user_type();
    }

    /**
     * Determine if the given user can create a buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('buy_ad.buyads.create');
    }

    /**
     * Determine if the given user can update the given buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function update(UserPolicy $user, Buyads $buyads)
    {
        if ($user->canDo('buy_ad.buyads.edit') && $user->isAdmin()) {
            return true;
        }

        return $buyads->user_id == user_id() && $buyads->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Buyads $buyads)
    {
        return $buyads->user_id == user_id() && $buyads->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Buyads $buyads)
    {
        if ($user->canDo('buy_ad.buyads.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given buyads.
     *
     * @param UserPolicy $user
     * @param Buyads $buyads
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Buyads $buyads)
    {
        if ($user->canDo('buy_ad.buyads.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
