<?php

namespace Litecms\BuyAd\Providers;

use Illuminate\Support\ServiceProvider;

class BuyAdServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'buy_ad');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'buy_ad');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.buy_ad', function ($app) {
            return $this->app->make('Litecms\BuyAd\BuyAd');
        });

                // Bind Buyads to repository
        $this->app->bind(
            'Litecms\BuyAd\Interfaces\BuyadsRepositoryInterface',
            \Litecms\BuyAd\Repositories\Eloquent\BuyadsRepository::class
        );

        $this->app->register(\Litecms\BuyAd\Providers\AuthServiceProvider::class);
                $this->app->register(\Litecms\BuyAd\Providers\EventServiceProvider::class);
        
        $this->app->register(\Litecms\BuyAd\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.buy_ad'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/buy_ad.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/buy_ad')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/buy_ad')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
