<?php

namespace Litecms\BuyAd\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BuyadsTransformer extends TransformerAbstract
{
    public function transform(\Litecms\BuyAd\Models\Buyads $buyads)
    {
        return [
            'id'                => $buyads->getRouteKey(),
            'key'               => [
                'public'    => $buyads->getPublicKey(),
                'route'     => $buyads->getRouteKey(),
            ], 
            'name'              => $buyads->name,
            'type'              => $buyads->type,
            'url'               => [
                'public'    => trans_url('buy_ad/'.$buyads->getPublicKey()),
                'user'      => guard_url('buy_ad/buyads/'.$buyads->getRouteKey()),
            ], 
            'status'            => trans('app.'.$buyads->status),
            'created_at'        => format_date($buyads->created_at),
            'updated_at'        => format_date($buyads->updated_at),
        ];
    }
}