<?php


return  
    [
        'model' => [
            'model' => \Litecms\Contact\Models\Contact::class,
            'table' => 'litecms_contact_contacts',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['type',  'ref',  'title',  'name',  'dob',  'nationality',  'religion',  'language',  'phone',  'mobile',  'mobile_track',  'fax',  'email',  'mobile_e',  'phone_e',  'email_e',  'address',  'designation',  'emirates_id',  'passport_no',  'facebook',  'twitter',  'linkedin',  'documents',  'notes',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'contact/contact',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            "type" => [
                "key" => "type", 
                "type" => "text", 
                "label" => 'contact::contact.label.type', 
                'sort' => true,
                'roles' => [],
            ],
            "ref" => [
                "key" => "ref", 
                "type" => "text", 
                "label" => 'contact::contact.label.ref', 
                'sort' => true,
                'roles' => [],
            ],
            "title" => [
                "key" => "title", 
                "type" => "text", 
                "label" => 'contact::contact.label.title', 
                'sort' => true,
                'roles' => [],
            ],
            "name" => [
                "key" => "name", 
                "type" => "text", 
                "label" => 'contact::contact.label.name', 
                'sort' => true,
                'roles' => [],
            ],
            "dob" => [
                "key" => "dob", 
                "type" => "text", 
                "label" => 'contact::contact.label.dob', 
                'sort' => true,
                'roles' => [],
            ],
            "nationality" => [
                "key" => "nationality", 
                "type" => "text", 
                "label" => 'contact::contact.label.nationality', 
                'sort' => true,
                'roles' => [],
            ],
            "religion" => [
                "key" => "religion", 
                "type" => "text", 
                "label" => 'contact::contact.label.religion', 
                'sort' => true,
                'roles' => [],
            ],
            "language" => [
                "key" => "language", 
                "type" => "text", 
                "label" => 'contact::contact.label.language', 
                'sort' => true,
                'roles' => [],
            ],
            "phone" => [
                "key" => "phone", 
                "type" => "text", 
                "label" => 'contact::contact.label.phone', 
                'sort' => true,
                'roles' => [],
            ],
            "mobile" => [
                "key" => "mobile", 
                "type" => "text", 
                "label" => 'contact::contact.label.mobile', 
                'sort' => true,
                'roles' => [],
            ],
            "mobile_track" => [
                "key" => "mobile_track", 
                "type" => "text", 
                "label" => 'contact::contact.label.mobile_track', 
                'sort' => true,
                'roles' => [],
            ],
            "fax" => [
                "key" => "fax", 
                "type" => "text", 
                "label" => 'contact::contact.label.fax', 
                'sort' => true,
                'roles' => [],
            ],
            "email" => [
                "key" => "email", 
                "type" => "text", 
                "label" => 'contact::contact.label.email', 
                'sort' => true,
                'roles' => [],
            ],
            "mobile_e" => [
                "key" => "mobile_e", 
                "type" => "text", 
                "label" => 'contact::contact.label.mobile_e', 
                'sort' => true,
                'roles' => [],
            ],
            "phone_e" => [
                "key" => "phone_e", 
                "type" => "text", 
                "label" => 'contact::contact.label.phone_e', 
                'sort' => true,
                'roles' => [],
            ],
            "email_e" => [
                "key" => "email_e", 
                "type" => "text", 
                "label" => 'contact::contact.label.email_e', 
                'sort' => true,
                'roles' => [],
            ],
            "address" => [
                "key" => "address", 
                "type" => "text", 
                "label" => 'contact::contact.label.address', 
                'sort' => true,
                'roles' => [],
            ],
            "designation" => [
                "key" => "designation", 
                "type" => "text", 
                "label" => 'contact::contact.label.designation', 
                'sort' => true,
                'roles' => [],
            ],
            "emirates_id" => [
                "key" => "emirates_id", 
                "type" => "text", 
                "label" => 'contact::contact.label.emirates_id', 
                'sort' => true,
                'roles' => [],
            ],
            "passport_no" => [
                "key" => "passport_no", 
                "type" => "text", 
                "label" => 'contact::contact.label.passport_no', 
                'sort' => true,
                'roles' => [],
            ],
            "facebook" => [
                "key" => "facebook", 
                "type" => "text", 
                "label" => 'contact::contact.label.facebook', 
                'sort' => true,
                'roles' => [],
            ],
            "twitter" => [
                "key" => "twitter", 
                "type" => "text", 
                "label" => 'contact::contact.label.twitter', 
                'sort' => true,
                'roles' => [],
            ],
            "linkedin" => [
                "key" => "linkedin", 
                "type" => "text", 
                "label" => 'contact::contact.label.linkedin', 
                'sort' => true,
                'roles' => [],
            ],
            "documents" => [
                "key" => "documents", 
                "type" => "text", 
                "label" => 'contact::contact.label.documents', 
                'sort' => true,
                'roles' => [],
            ],
            "notes" => [
                "key" => "notes", 
                "type" => "text", 
                "label" => 'contact::contact.label.notes', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            'type' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.type',
                "placeholder" => 'contact::contact.placeholder.type',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'ref' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.ref',
                "placeholder" => 'contact::contact.placeholder.ref',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'title' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.title',
                "placeholder" => 'contact::contact.placeholder.title',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.name',
                "placeholder" => 'contact::contact.placeholder.name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'dob' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => 'contact::contact.label.dob',
                "placeholder" => 'contact::contact.placeholder.dob',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'nationality' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.nationality',
                "placeholder" => 'contact::contact.placeholder.nationality',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'religion' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.religion',
                "placeholder" => 'contact::contact.placeholder.religion',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'language' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.language',
                "placeholder" => 'contact::contact.placeholder.language',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'phone' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.phone',
                "placeholder" => 'contact::contact.placeholder.phone',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'mobile' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.mobile',
                "placeholder" => 'contact::contact.placeholder.mobile',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'mobile_track' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.mobile_track',
                "placeholder" => 'contact::contact.placeholder.mobile_track',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'fax' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.fax',
                "placeholder" => 'contact::contact.placeholder.fax',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'email' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.email',
                "placeholder" => 'contact::contact.placeholder.email',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'mobile_e' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.mobile_e',
                "placeholder" => 'contact::contact.placeholder.mobile_e',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'phone_e' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.phone_e',
                "placeholder" => 'contact::contact.placeholder.phone_e',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'email_e' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.email_e',
                "placeholder" => 'contact::contact.placeholder.email_e',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'address' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.address',
                "placeholder" => 'contact::contact.placeholder.address',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'designation' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.designation',
                "placeholder" => 'contact::contact.placeholder.designation',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'emirates_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.emirates_id',
                "placeholder" => 'contact::contact.placeholder.emirates_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'passport_no' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.passport_no',
                "placeholder" => 'contact::contact.placeholder.passport_no',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'facebook' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.facebook',
                "placeholder" => 'contact::contact.placeholder.facebook',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'twitter' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.twitter',
                "placeholder" => 'contact::contact.placeholder.twitter',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'linkedin' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.linkedin',
                "placeholder" => 'contact::contact.placeholder.linkedin',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'documents' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.documents',
                "placeholder" => 'contact::contact.placeholder.documents',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'notes' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'contact::contact.label.notes',
                "placeholder" => 'contact::contact.placeholder.notes',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'contact/contact/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'contact/contact/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'contact/contact',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'contact/contact',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'contact/contact',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'contact/contact',
                'method' => 'DELETE',
            ],
        ],
        'order' => [
            'created_at' => 'contact::contact.label.created_at',
            'name' => 'contact::contact.label.name',
            'status' => 'contact::contact.label.status',
        ],
        'groups' => [
            'main' => 'contact::contact.groups.main',
            'details' => 'contact::contact.groups.details',
            'images' => 'contact::contact.groups.images',
            'settings' => 'contact::contact.groups.settings',
        ],
        'controller' => [
            'provider' => 'Litecms',
            'package' => 'Contact',
            'module' => 'Contact',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Litecms\Contact\Models\Contact::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'count' => [
                                "element" => 'select',
                                "type" => 'select',
                                "label" => 'contact::contact.label.count',
                                "placeholder" => 'contact::contact.placeholder.count',
                                "options" => call_user_func(function () {
                                    return [
                                        1 => ['value' => 1, 'text' => 1],
                                        2 => ['value' => 2, 'text' => 2],
                                        3 => ['value' => 3, 'text' => 3],
                                        4 => ['value' => 4, 'text' => 4]
                                    ];
                                }),
                                "col" => "12",
                            ],
                            'comment' => [
                                "element" => 'textarea',
                                "type" => 'text',
                                "required" => 'required',
                                "label" => 'contact::contact.label.comment',
                                "placeholder" => 'contact::contact.placeholder.comment',
                                "col" => "12",
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
         
        'actions' => [
            'copy' => [
                'type' => ['Details', 'List'],
                'label' => 'contact::contact.action.copy',
                'roles' => [
                    'user' => ['superuser', 'admin'],
                    'team' => ['admin'],
                    'permission' => ['contact.contact.copy', 'contact.contact.duplicate'],
                ],
                'form' => [
                    'count' => [
                        "element" => 'select',
                        "type" => 'select',
                        "label" => 'contact::contact.label.count',
                        "placeholder" => 'contact::contact.placeholder.count',
                        "options" => call_user_func(function () {
                            return [
                                1 => ['value' => 1, 'text' => 1],
                                2 => ['value' => 2, 'text' => 2],
                                3 => ['value' => 3, 'text' => 3],
                                4 => ['value' => 4, 'text' => 4],
                            ];
                        }),
                        "col" => "12",
                    ],
                    'comment' => [
                        "element" => 'textarea',
                        "type" => 'text',
                        "required" => 'required',
                        "label" => 'contact::contact.label.comment',
                        "placeholder" => 'contact::contact.placeholder.comment',
                        "col" => "12",
                    ],
                ],
            ],
            'empty' => [
                'type' => ['List', 'Details'],
                'label' => 'contact::contact.action.empty',
                'roles' => [
                    'user' => ['superuser'],
                ],
            ],
        ]
        
    ];
