<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateLitecmsContactContactsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: litecms_contact_contacts
         */
        Schema::create('litecms_contact_contacts', function ($table) {
            $table->increments('id');
            $table->string('type', 100)->nullable();
            $table->string('ref', 100)->nullable();
            $table->string('title', 10)->nullable();
            $table->string('name', 150)->nullable();
            $table->date('dob')->nullable();
            $table->string('nationality', 100)->nullable();
            $table->string('religion', 100)->nullable();
            $table->string('language', 100)->nullable();
            $table->string('phone', 255)->nullable();
            $table->string('mobile', 255)->nullable();
            $table->string('mobile_track', 255)->nullable();
            $table->text('fax')->nullable();
            $table->string('email', 255)->nullable();
            $table->string('mobile_e', 500)->nullable();
            $table->string('phone_e', 500)->nullable();
            $table->string('email_e', 500)->nullable();
            $table->text('address')->nullable();
            $table->string('designation', 100)->nullable();
            $table->string('emirates_id', 50)->nullable();
            $table->string('passport_no', 50)->nullable();
            $table->string('facebook', 50)->nullable();
            $table->string('twitter', 50)->nullable();
            $table->string('linkedin', 50)->nullable();
            $table->text('documents')->nullable();
            $table->text('notes')->nullable();
            $table->string('upload_folder', 255)->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 50)->nullable();
            $table->text('marking', 200)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('litecms_contact_contacts');
    }
}
