<?php

namespace Litecms\Contact\Seeders;

use DB;
use Illuminate\Database\Seeder;

class ContactTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('litecms_contact_contacts')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'litecms.contact.contact.view',
                'name'      => 'View Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.create',
                'name'      => 'Create Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.edit',
                'name'      => 'Update Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.delete',
                'name'      => 'Delete Contact',
            ],
            
                        [
                'slug'      => 'litecms.contact.contact.verify',
                'name'      => 'Verify Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.approve',
                'name'      => 'Approve Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.publish',
                'name'      => 'Publish Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.unpublish',
                'name'      => 'Unpublish Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.cancel',
                'name'      => 'Cancel Contact',
            ],
            [
                'slug'      => 'litecms.contact.contact.archive',
                'name'      => 'Archive Contact',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/contact/contact',
                'name'        => 'Contact',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/contact/contact',
                'name'        => 'Contact',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'contact',
                'name'        => 'Contact',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Contact',
                'module'    => 'Contact',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'litecms.contact.contact.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
