<?php

namespace Litecms\Contact\Actions;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Litecms\Contact\Models\Contact;
use Litepie\Actions\Concerns\AsAction;

class ContactAction
{
    use AsAction;

    private $model;

    public function handle(Request $request, Contact $contact, string $action)
    {
        $this->model = $contact;

        $function = Str::camel($action);
        return $this->$function($contact, $request);
    }

    public function copy(Contact $contact, Request $request)
    {
        return $contact;
    }

    public function empty(Contact $contact, Request $request)
    {
        return $contact;
    }

}
