<?php

namespace Litecms\Contact\Actions;

use Illuminate\Http\Request;
use Litecms\Contact\Models\Contact;
use Litepie\Actions\Concerns\AsAction;
use Illuminate\Support\Str;

class ContactWorkflow
{
    use AsAction;

    public function handle(Request $request, Contact $contact, string $transition)
    {
        $this->model = $contact;
        $contact->workflow()->apply($contact, $transition);
        $transition = Str::camel($transition);
        return $this->$transition($contact);
    }

    public function submit()
    {
        $this->model->status = 'Pending';
        $this->model->save();
        return $this->model;
    }

    public function approve()
    {
        $this->model->status = 'Approved';
        $this->model->save();
        return $this->model;
    }

    public function reject()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }

    public function publish()
    {
        $this->model->status = 'Published';
        $this->model->save();
        return $this->model;
    }

    public function unpublish()
    {
        $this->model->status = 'Unpublished';
        $this->model->save();
        return $this->model;
    }

    public function archive()
    {
        $this->model->status = 'Archived';
        $this->model->save();
        return $this->model;
    }

    public function unarchive()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }
}
