<?php

namespace Litecms\Contact\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Litecms\Contact\Actions\ContactAction;
use Litecms\Contact\Http\Requests\ContactActionRequest;
use Litecms\Contact\Http\Resources\ContactResource;
use Litecms\Contact\Models\Contact;

/**
 * Admin web controller class.
 */
class ContactActionController extends BaseController
{

    /**
     * Action controller function for contact.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(ContactActionRequest $request, Contact $contact, $action)
    {
        try {
            $contact = ContactAction::run($request, $contact, $action);

            $data = new ContactResource($contact);
            return $this->response->message(trans("messages.success.{$action}", ['Module' => trans('contact::contact.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('contact/contact/' . $contact->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('contact/contact/' . $contact->getRouteKey()))
                ->redirect();
        }
    }

    public function notify(){
        
    }
}
