<?php

namespace Litecms\Contact\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Exception;
use Litecms\Contact\Http\Requests\ContactActionsRequest;
use Litecms\Contact\Models\ContactActions;

/**
 * Admin web controller class.
 */
class ContactActionsController extends BaseController
{

    /**
     * Action controller function for contact.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(ContactActionsRequest $request, $action)
    {
        try {
            $contact = ContactActions::run($request, $action);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('contact::contact.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('contact/contact/' . $action))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('contact/contact/' . $action))
                ->redirect();
        }
    }
}
