<?php

namespace Litecms\Contact\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Illuminate\Support\Str;
use Litecms\Contact\Actions\ContactExim;
use Litecms\Contact\Http\Requests\ContactEximRequest;

/**
 * Admin web controller class.
 */
class ContactEximController extends BaseController
{
    /**
     * Action controller function for contact.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(ContactEximRequest $request, $exim)
    {
        try {
            $function = Str::camel($exim);
            $data = ContactExim::$function($request);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('contact:contact.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('contact/contact/' . $exim))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('contact/contact/' . $exim))
                ->redirect();
        }
    }
}
