<?php

namespace Litecms\Contact\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Litecms\Contact\Actions\ContactReport;
use Litecms\Contact\Http\Requests\ContactReportRequest;

/**
 * Admin web controller class.
 */
class ContactReportController extends BaseController
{
    /**
     * Action controller function for contact.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(ContactReportRequest $request, $report)
    {
        try {
        
            $this->model = app(Contact::class);
            $data = ContactReport::run($request, $report);

            return $this->response->message(trans('messages.success.updated', ['Module' => trans('contact::contact.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('contact/contact/' . $report))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('contact/contact/' . $report))
                ->redirect();
        }
    }
}
