<?php

namespace Litecms\Contact\Http\Controllers;

use Exception;
use Litecms\Contact\Actions\ContactWorkflow;
use Litecms\Contact\Http\Requests\ContactWorkflowRequest;
use Litecms\Contact\Http\Resources\ContactResource;
use Litecms\Contact\Models\Contact;
use Litepie\Http\Controllers\ActionController as BaseController;

/**
 * Workflow controller class.
 *
 */
class ContactWorkflowController extends BaseController
{
    /**
     * Action controller function for contact.
     *
     * @param Model $contact
     * @param action next action for the contact.
     *
     * @return Response
     */
    public function __invoke(ContactWorkflowRequest $request, Contact $contact, $trasition)
    {
        try {
            $contact = ContactWorkflow::run($request, $contact, $trasition);
            $data = new ContactResource($contact);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('contact::contact.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('contact/contact/' . $contact->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('contact/contact/' . $contact->getRouteKey()))
                ->redirect();
        }
    }
}
