<?php

namespace Litecms\Contact\Http\Requests;

use Litepie\Http\Request\AbstractRequest;
use Litecms\Contact\Models\Contact;

class ContactReportRequest extends AbstractRequest
{


    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $this->model = app(Contact::class);

        if ($this->isExport()) {
            // Determine if the user is authorized to export the data.
            return $this->can('export');
        }

        if ($this->isImport()) {
            // Determine if the user is authorized to import the data.
            return $this->can('import');
        }

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

}
