<?php

namespace Litecms\Contact\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ContactResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('contact/contact') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'type' => $this->type,
            'ref' => $this->ref,
            'title' => $this->title,
            'name' => $this->name,
            'dob' => $this->dob,
            'nationality' => $this->nationality,
            'religion' => $this->religion,
            'language' => $this->language,
            'phone' => $this->phone,
            'mobile' => $this->mobile,
            'mobile_track' => $this->mobile_track,
            'fax' => $this->fax,
            'email' => $this->email,
            'mobile_e' => $this->mobile_e,
            'phone_e' => $this->phone_e,
            'email_e' => $this->email_e,
            'address' => $this->address,
            'designation' => $this->designation,
            'emirates_id' => $this->emirates_id,
            'passport_no' => $this->passport_no,
            'facebook' => $this->facebook,
            'twitter' => $this->twitter,
            'linkedin' => $this->linkedin,
            'documents' => $this->documents,
            'notes' => $this->notes,
            'upload_folder' => $this->upload_folder,
            'user_id' => $this->user_id,
            'user_type' => $this->user_type,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }

    /**
     * Get additional data that should be returned with the resource array.
     *
     * @param   \Illuminate\Http\Request  $request
     * @return array
     */
    public function with($request)
    {
        return [
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
                'workflow' => $this->workflows(),
                'actions' => $this->actions(),
            ],
        ];
    }

    private function workflows()
    {
        $arr = [];
                $workflow = $this->workflow();
        foreach ($workflow->transitions($this) as $key => $transition) {
            $name = $transition->getName();
            $arr[$key]['url'] = guard_url('contact/contact/workflow/' . $this->getRouteKey() . '/' . $name);
            $arr[$key]['name'] = $name;
            $arr[$key]['key'] = $name;
            $arr[$key]['form'] = $workflow->form($transition);
            $arr[$key]['label'] = trans('contact::contact.workflow.' . $name);
        }
                return $arr;

    }
    private function actions()
    {

        $arr = [];
                $actions = $this->resource->actions()->details();
        foreach ($actions as $key => $action) {
            $name = $action->name();
            $arr[$key]['url'] = guard_url('contact/contact//action' . $this->getRouteKey() . '/' . $action->name());
            $arr[$key]['name'] = $name;
            $arr[$key]['key'] = $name;
            $arr[$key]['form'] = $action->form();
            $arr[$key]['label'] = trans('contact::contact.actions.' . $name);
        }
        
        return $arr;
    }
}
