<?php

namespace Litecms\Contact\Policies;

use Litecms\Contact\Models\Contact;
use Litepie\User\Interfaces\UserPolicyInterface;

trait ContactAction
{

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function copy(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->is($this->model->owner())) {
            return true;
        }

        if ($authUser->canDo('contact.contact.action.copy')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    function empty(UserPolicyInterface $authUser, Contact $contact) {
        if ($authUser->is($this->model->owner())) {
            return true;
        }

        if ($authUser->canDo('contact.contact.action.empty')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function transfer(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->is($this->model->owner())) {
            return true;
        }

        if ($authUser->canDo('contact.contact.action.transfer')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function delete(UserPolicyInterface $authUser, Contact $contact)
    {


        if ($authUser->canDo('contact.contact.action.delete')) {
            return true;
        }

        return false;
    }


}
