<?php

namespace Litecms\Contact\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;

trait ContactExim
{

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function import(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('contact.contact.import')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function export(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('contact.contact.export')) {
            return true;
        }

        return false;
    }
}
