<?php


namespace Litecms\Contact\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;

trait ContactReport
{

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function povote(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('contact.contact.report.povote')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function report(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('contact.contact.report')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function download(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('contact.contact.report.download')) {
            return true;
        }

        return false;
    }
}
