<?php

namespace Litecms\Contact\Policies;

use Litecms\Contact\Models\Contact;
use Litepie\User\Interfaces\UserPolicyInterface;

trait ContactWorkflow
{

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function submit(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function publish(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function unpublish(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function archive(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function unarchive(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contact.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function reject(UserPolicyInterface $authUser, Contact $contact)
    {
        if ($authUser->canDo('contact.contact.reject')) {
            return true;
        }

        return false;
    }

}
