<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'coupanfield',

    /*
     * Modules.
     */
    'modules'   => ['coupanfields'],

    
    'coupanfields'       => [
        'model' => [
            'model'                 => \Litecms\Coupanfield\Models\Coupanfields::class,
            'table'                 => 'coupanfields',
            'presenter'             => \Litecms\Coupanfield\Repositories\Presenter\CoupanfieldsPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['offered_by',  'coupan_type',  'coupan_code',  'description',  'status',  'amount',  'is_amount_pct',  'min_order_amt',  'seller_ids',  'user_ids',  'product_id',  'start_time',  'end_time',  'max_redem_count',  'max_redem_amt',  'redem_count',  'redem_amount'],
            'translatables'         => [],
            'upload_folder'         => 'coupanfield/coupanfields',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'Coupanfield',
            'module'    => 'Coupanfields',
        ],

    ],
];
