<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateCoupanfieldsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: coupanfields
         */
        Schema::create('coupanfields', function ($table) {
            $table->increments('id');
            $table->text('offered_by')->nullable();
            $table->text('coupan_type')->nullable();
            $table->text('coupan_code')->nullable();
            $table->text('description')->nullable();
            $table->text('status')->nullable();
            $table->text('amount')->nullable();
            $table->text('is_amount_pct')->nullable();
            $table->text('min_order_amt')->nullable();
            $table->text('seller_ids')->nullable();
            $table->text('user_ids')->nullable();
            $table->text('product_id')->nullable();
            $table->dateTime('start_time')->nullable();
            $table->dateTime('end_time')->nullable();
            $table->text('max_redem_count')->nullable();
            $table->text('max_redem_amt')->nullable();
            $table->text('redem_count')->nullable();
            $table->text('redem_amount')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('coupanfields');
    }
}
