<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('coupanfield::coupanfields.name') !!} <small> {!! trans('app.manage') !!} {!! trans('coupanfield::coupanfields.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('coupanfield::coupanfields.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='coupanfield-coupanfields-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('coupanfield/coupanfields')!!}">{!! trans('coupanfield::coupanfields.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('coupanfield/coupanfields?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('coupanfield/coupanfields?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('coupanfield/coupanfields/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('coupanfield::admin.coupanfields.partial.actions')
                    -->
                    @include('coupanfield::admin.coupanfields.partial.filter')
                    @include('coupanfield::admin.coupanfields.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="coupanfield-coupanfields-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="coupanfield-coupanfields-check-all"></th>
                        <th data-field="offered_by">{!! trans('coupanfield::coupanfields.label.offered_by')!!}</th>
                    <th data-field="coupan_type">{!! trans('coupanfield::coupanfields.label.coupan_type')!!}</th>
                    <th data-field="coupan_code">{!! trans('coupanfield::coupanfields.label.coupan_code')!!}</th>
                    <th data-field="description">{!! trans('coupanfield::coupanfields.label.description')!!}</th>
                    <th data-field="status">{!! trans('coupanfield::coupanfields.label.status')!!}</th>
                    <th data-field="amount">{!! trans('coupanfield::coupanfields.label.amount')!!}</th>
                    <th data-field="is_amount_pct">{!! trans('coupanfield::coupanfields.label.is_amount_pct')!!}</th>
                    <th data-field="min_order_amt">{!! trans('coupanfield::coupanfields.label.min_order_amt')!!}</th>
                    <th data-field="seller_ids">{!! trans('coupanfield::coupanfields.label.seller_ids')!!}</th>
                    <th data-field="user_ids">{!! trans('coupanfield::coupanfields.label.user_ids')!!}</th>
                    <th data-field="product_id">{!! trans('coupanfield::coupanfields.label.product_id')!!}</th>
                    <th data-field="start_time">{!! trans('coupanfield::coupanfields.label.start_time')!!}</th>
                    <th data-field="end_time">{!! trans('coupanfield::coupanfields.label.end_time')!!}</th>
                    <th data-field="max_redem_count">{!! trans('coupanfield::coupanfields.label.max_redem_count')!!}</th>
                    <th data-field="max_redem_amt">{!! trans('coupanfield::coupanfields.label.max_redem_amt')!!}</th>
                    <th data-field="redem_count">{!! trans('coupanfield::coupanfields.label.redem_count')!!}</th>
                    <th data-field="redem_amount">{!! trans('coupanfield::coupanfields.label.redem_amount')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#coupanfield-coupanfields-entry', '{!!guard_url('coupanfield/coupanfields/0')!!}');
    oTable = $('#coupanfield-coupanfields-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('coupanfield/coupanfields') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'offered_by'},
            {data :'coupan_type'},
            {data :'coupan_code'},
            {data :'description'},
            {data :'status'},
            {data :'amount'},
            {data :'is_amount_pct'},
            {data :'min_order_amt'},
            {data :'seller_ids'},
            {data :'user_ids'},
            {data :'product_id'},
            {data :'start_time'},
            {data :'end_time'},
            {data :'max_redem_count'},
            {data :'max_redem_amt'},
            {data :'redem_count'},
            {data :'redem_amount'},
        ],
        "pageLength": 25
    });

    $('#coupanfield-coupanfields-list tbody').on( 'click', 'tr td:not(:first-child)', function (e) {
        e.preventDefault();

        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#coupanfield-coupanfields-list').DataTable().row( this ).data();
        $('#coupanfield-coupanfields-entry').load('{!!guard_url('coupanfield/coupanfields')!!}' + '/' + d.id);
    });

    $('#coupanfield-coupanfields-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#coupanfield-coupanfields-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#coupanfield-coupanfields-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#coupanfield-coupanfields-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>