<?php

namespace Litecms\Coupanfield\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\Coupanfield\Interfaces\CoupanfieldsRepositoryInterface;

class CoupanfieldsPublicController extends BaseController
{
    // use CoupanfieldsWorkflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\Coupanfields\Interfaces\CoupanfieldsRepositoryInterface $coupanfields
     *
     * @return type
     */
    public function __construct(CoupanfieldsRepositoryInterface $coupanfields)
    {
        $this->repository = $coupanfields;
        parent::__construct();
    }

    /**
     * Show coupanfields's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $coupanfields = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$coupanfield::$coupanfields.names'))
            ->view('$coupanfield::public.coupanfields.index')
            ->data(compact('$coupanfields'))
            ->output();
    }

    /**
     * Show coupanfields's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $coupanfields = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$coupanfield::$coupanfields.names'))
            ->view('$coupanfield::public.coupanfields.index')
            ->data(compact('$coupanfields'))
            ->output();
    }

    /**
     * Show coupanfields.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $coupanfields = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$coupanfields->name . trans('$coupanfield::$coupanfields.name'))
            ->view('$coupanfield::public.coupanfields.show')
            ->data(compact('$coupanfields'))
            ->output();
    }

}
