<?php

namespace Litecms\Coupanfield\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\Coupanfield\Http\Requests\CoupanfieldsRequest;
use Litecms\Coupanfield\Interfaces\CoupanfieldsRepositoryInterface;
use Litecms\Coupanfield\Models\Coupanfields;

/**
 * Resource controller class for coupanfields.
 */
class CoupanfieldsResourceController extends BaseController
{

    /**
     * Initialize coupanfields resource controller.
     *
     * @param type CoupanfieldsRepositoryInterface $coupanfields
     *
     * @return null
     */
    public function __construct(CoupanfieldsRepositoryInterface $coupanfields)
    {
        parent::__construct();
        $this->repository = $coupanfields;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\Coupanfield\Repositories\Criteria\CoupanfieldsResourceCriteria::class);
    }

    /**
     * Display a list of coupanfields.
     *
     * @return Response
     */
    public function index(CoupanfieldsRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\Coupanfield\Repositories\Presenter\CoupanfieldsPresenter::class)
                ->$function();
        }

        $coupanfields = $this->repository->paginate();

        return $this->response->title(trans('coupanfield::coupanfields.names'))
            ->view('coupanfield::coupanfields.index', true)
            ->data(compact('coupanfields'))
            ->output();
    }

    /**
     * Display coupanfields.
     *
     * @param Request $request
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function show(CoupanfieldsRequest $request, Coupanfields $coupanfields)
    {

        if ($coupanfields->exists) {
            $view = 'coupanfield::coupanfields.show';
        } else {
            $view = 'coupanfield::coupanfields.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('coupanfield::coupanfields.name'))
            ->data(compact('coupanfields'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new coupanfields.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(CoupanfieldsRequest $request)
    {

        $coupanfields = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('coupanfield::coupanfields.name')) 
            ->view('coupanfield::coupanfields.create', true) 
            ->data(compact('coupanfields'))
            ->output();
    }

    /**
     * Create new coupanfields.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(CoupanfieldsRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $coupanfields                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('coupanfield::coupanfields.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('coupanfield/coupanfields/' . $coupanfields->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/coupanfield/coupanfields'))
                ->redirect();
        }

    }

    /**
     * Show coupanfields for editing.
     *
     * @param Request $request
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function edit(CoupanfieldsRequest $request, Coupanfields $coupanfields)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('coupanfield::coupanfields.name'))
            ->view('coupanfield::coupanfields.edit', true)
            ->data(compact('coupanfields'))
            ->output();
    }

    /**
     * Update the coupanfields.
     *
     * @param Request $request
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function update(CoupanfieldsRequest $request, Coupanfields $coupanfields)
    {
        try {
            $attributes = $request->all();

            $coupanfields->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('coupanfield::coupanfields.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('coupanfield/coupanfields/' . $coupanfields->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('coupanfield/coupanfields/' . $coupanfields->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the coupanfields.
     *
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function destroy(CoupanfieldsRequest $request, Coupanfields $coupanfields)
    {
        try {

            $coupanfields->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('coupanfield::coupanfields.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('coupanfield/coupanfields/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('coupanfield/coupanfields/' . $coupanfields->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple coupanfields.
     *
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function delete(CoupanfieldsRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('coupanfield::coupanfields.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('coupanfield/coupanfields'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/coupanfield/coupanfields'))
                ->redirect();
        }

    }

    /**
     * Restore deleted coupanfields.
     *
     * @param Model   $coupanfields
     *
     * @return Response
     */
    public function restore(CoupanfieldsRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('coupanfield::coupanfields.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/coupanfield/coupanfields'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/coupanfield/coupanfields/'))
                ->redirect();
        }

    }

}
