<?php

namespace Litecms\Coupanfield\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Coupanfield\Models\Coupanfields;

class CoupanfieldsPolicy
{

    /**
     * Determine if the given user can view the coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function view(UserPolicy $user, Coupanfields $coupanfields)
    {
        if ($user->canDo('coupanfield.coupanfields.view') && $user->isAdmin()) {
            return true;
        }

        return $coupanfields->user_id == user_id() && $coupanfields->user_type == user_type();
    }

    /**
     * Determine if the given user can create a coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('coupanfield.coupanfields.create');
    }

    /**
     * Determine if the given user can update the given coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function update(UserPolicy $user, Coupanfields $coupanfields)
    {
        if ($user->canDo('coupanfield.coupanfields.edit') && $user->isAdmin()) {
            return true;
        }

        return $coupanfields->user_id == user_id() && $coupanfields->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Coupanfields $coupanfields)
    {
        return $coupanfields->user_id == user_id() && $coupanfields->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Coupanfields $coupanfields)
    {
        if ($user->canDo('coupanfield.coupanfields.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given coupanfields.
     *
     * @param UserPolicy $user
     * @param Coupanfields $coupanfields
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Coupanfields $coupanfields)
    {
        if ($user->canDo('coupanfield.coupanfields.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
