<?php

namespace Litecms\Coupanfield\Providers;

use Illuminate\Support\ServiceProvider;

class CoupanfieldServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'coupanfield');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'coupanfield');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.coupanfield', function ($app) {
            return $this->app->make('Litecms\Coupanfield\Coupanfield');
        });

                // Bind Coupanfields to repository
        $this->app->bind(
            'Litecms\Coupanfield\Interfaces\CoupanfieldsRepositoryInterface',
            \Litecms\Coupanfield\Repositories\Eloquent\CoupanfieldsRepository::class
        );

        $this->app->register(\Litecms\Coupanfield\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\Coupanfield\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.coupanfield'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/coupanfield.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/coupanfield')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/coupanfield')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
