<?php

namespace Litecms\Coupanfield\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class CoupanfieldsTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Coupanfield\Models\Coupanfields $coupanfields)
    {
        return [
            'id'                => $coupanfields->getRouteKey(),
            'key'               => [
                'public'    => $coupanfields->getPublicKey(),
                'route'     => $coupanfields->getRouteKey(),
            ], 
            'offered_by'        => $coupanfields->offered_by,
            'coupan_type'       => $coupanfields->coupan_type,
            'coupan_code'       => $coupanfields->coupan_code,
            'description'       => $coupanfields->description,
            'status'            => $coupanfields->status,
            'amount'            => $coupanfields->amount,
            'is_amount_pct'     => $coupanfields->is_amount_pct,
            'min_order_amt'     => $coupanfields->min_order_amt,
            'seller_ids'        => $coupanfields->seller_ids,
            'user_ids'          => $coupanfields->user_ids,
            'product_id'        => $coupanfields->product_id,
            'start_time'        => $coupanfields->start_time,
            'end_time'          => $coupanfields->end_time,
            'max_redem_count'   => $coupanfields->max_redem_count,
            'max_redem_amt'     => $coupanfields->max_redem_amt,
            'redem_count'       => $coupanfields->redem_count,
            'redem_amount'      => $coupanfields->redem_amount,
            'url'               => [
                'public'    => trans_url('coupanfield/'.$coupanfields->getPublicKey()),
                'user'      => guard_url('coupanfield/coupanfields/'.$coupanfields->getRouteKey()),
            ], 
            'status'            => trans('app.'.$coupanfields->status),
            'created_at'        => format_date($coupanfields->created_at),
            'updated_at'        => format_date($coupanfields->updated_at),
        ];
    }
}