# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/123/321/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/123/321"
        }

        ...
    },
...

```
Then run `composer require 123/321`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=123\\321\\Seeders\\321TableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="123\321\Providers\321ServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="123\321\Providers\321ServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="123\321\Providers\321ServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/321/{modulename}
```

* User
```
    http://path-to-route-folder/user/321/{modulename}
```

* Public
```
    http://path-to-route-folder/321s
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/321/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/321/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/321/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/321/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/321/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/321/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/321/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/321/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/321/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/321/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/321/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
