<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'job_applicant',

    /*
     * Modules.
     */
    'modules'   => ['job_applicant'],

    
    'job_applicant'       => [
        'model' => [
            'model'                 => \Litecms\JobApplicant\Models\JobApplicant::class,
            'table'                 => 'job_applicants',
            'presenter'             => \Litecms\JobApplicant\Repositories\Presenter\JobApplicantPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['job_id',  'user_id',  'type',  'comment ',  'status'],
            'translatables'         => [],
            'upload_folder'         => 'job_applicant/job_applicant',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'JobApplicant',
            'module'    => 'JobApplicant',
        ],

    ],
];
