<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateJobApplicantsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: job_applicants
         */
        Schema::create('job_applicants', function ($table) {
            $table->increments('id');
            $table->integer('job_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->enum('type', [job_request, job_supporter])->nullable();
            $table->text('comment ')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('job_applicants');
    }
}
