<?php

namespace Litecms\JobApplicant\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\JobApplicant\Http\Requests\JobApplicantRequest;
use Litecms\JobApplicant\Interfaces\JobApplicantRepositoryInterface;
use Litecms\JobApplicant\Models\JobApplicant;

/**
 * Resource controller class for job_applicant.
 */
class JobApplicantResourceController extends BaseController
{

    /**
     * Initialize job_applicant resource controller.
     *
     * @param type JobApplicantRepositoryInterface $job_applicant
     *
     * @return null
     */
    public function __construct(JobApplicantRepositoryInterface $job_applicant)
    {
        parent::__construct();
        $this->repository = $job_applicant;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\JobApplicant\Repositories\Criteria\JobApplicantResourceCriteria::class);
    }

    /**
     * Display a list of job_applicant.
     *
     * @return Response
     */
    public function index(JobApplicantRequest $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\JobApplicant\Repositories\Presenter\JobApplicantPresenter::class)
                ->$function();
        }

        $job_applicants = $this->repository->paginate();

        return $this->response->title(trans('job_applicant::job_applicant.names'))
            ->view('job_applicant::job_applicant.index', true)
            ->data(compact('job_applicants'))
            ->output();
    }

    /**
     * Display job_applicant.
     *
     * @param Request $request
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function show(JobApplicantRequest $request, JobApplicant $job_applicant)
    {

        if ($job_applicant->exists) {
            $view = 'job_applicant::job_applicant.show';
        } else {
            $view = 'job_applicant::job_applicant.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('job_applicant::job_applicant.name'))
            ->data(compact('job_applicant'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new job_applicant.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(JobApplicantRequest $request)
    {

        $job_applicant = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('job_applicant::job_applicant.name')) 
            ->view('job_applicant::job_applicant.create', true) 
            ->data(compact('job_applicant'))
            ->output();
    }

    /**
     * Create new job_applicant.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(JobApplicantRequest $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $job_applicant                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('job_applicant::job_applicant.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('job_applicant/job_applicant/' . $job_applicant->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/job_applicant/job_applicant'))
                ->redirect();
        }

    }

    /**
     * Show job_applicant for editing.
     *
     * @param Request $request
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function edit(JobApplicantRequest $request, JobApplicant $job_applicant)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('job_applicant::job_applicant.name'))
            ->view('job_applicant::job_applicant.edit', true)
            ->data(compact('job_applicant'))
            ->output();
    }

    /**
     * Update the job_applicant.
     *
     * @param Request $request
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function update(JobApplicantRequest $request, JobApplicant $job_applicant)
    {
        try {
            $attributes = $request->all();

            $job_applicant->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('job_applicant::job_applicant.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('job_applicant/job_applicant/' . $job_applicant->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('job_applicant/job_applicant/' . $job_applicant->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the job_applicant.
     *
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function destroy(JobApplicantRequest $request, JobApplicant $job_applicant)
    {
        try {

            $job_applicant->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('job_applicant::job_applicant.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('job_applicant/job_applicant/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('job_applicant/job_applicant/' . $job_applicant->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple job_applicant.
     *
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function delete(JobApplicantRequest $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('job_applicant::job_applicant.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('job_applicant/job_applicant'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/job_applicant/job_applicant'))
                ->redirect();
        }

    }

    /**
     * Restore deleted job_applicants.
     *
     * @param Model   $job_applicant
     *
     * @return Response
     */
    public function restore(JobApplicantRequest $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('job_applicant::job_applicant.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/job_applicant/job_applicant'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/job_applicant/job_applicant/'))
                ->redirect();
        }

    }

}
