<?php

namespace Litecms\JobApplicant;

use User;

class JobApplicant
{
    /**
     * $job_applicant object.
     */
    protected $job_applicant;

    /**
     * Constructor.
     */
    public function __construct(\Litecms\JobApplicant\Interfaces\JobApplicantRepositoryInterface $job_applicant)
    {
        $this->job_applicant = $job_applicant;
    }

    /**
     * Returns count of job_applicant.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.job_applicant.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->job_applicant->pushCriteria(new \Litepie\Litecms\Repositories\Criteria\JobApplicantUserCriteria());
        }

        $job_applicant = $this->job_applicant->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('job_applicant::' . $view, compact('job_applicant'))->render();
    }
}
