<?php

namespace Litecms\JobApplicant\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\JobApplicant\Models\JobApplicant;

class JobApplicantPolicy
{

    /**
     * Determine if the given user can view the job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function view(UserPolicy $user, JobApplicant $job_applicant)
    {
        if ($user->canDo('job_applicant.job_applicant.view') && $user->isAdmin()) {
            return true;
        }

        return $job_applicant->user_id == user_id() && $job_applicant->user_type == user_type();
    }

    /**
     * Determine if the given user can create a job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('job_applicant.job_applicant.create');
    }

    /**
     * Determine if the given user can update the given job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function update(UserPolicy $user, JobApplicant $job_applicant)
    {
        if ($user->canDo('job_applicant.job_applicant.edit') && $user->isAdmin()) {
            return true;
        }

        return $job_applicant->user_id == user_id() && $job_applicant->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, JobApplicant $job_applicant)
    {
        return $job_applicant->user_id == user_id() && $job_applicant->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function verify(UserPolicy $user, JobApplicant $job_applicant)
    {
        if ($user->canDo('job_applicant.job_applicant.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given job_applicant.
     *
     * @param UserPolicy $user
     * @param JobApplicant $job_applicant
     *
     * @return bool
     */
    public function approve(UserPolicy $user, JobApplicant $job_applicant)
    {
        if ($user->canDo('job_applicant.job_applicant.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
