<?php

namespace Litecms\JobApplicant\Providers;

use Illuminate\Support\ServiceProvider;

class JobApplicantServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'job_applicant');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'job_applicant');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.job_applicant', function ($app) {
            return $this->app->make('Litecms\JobApplicant\JobApplicant');
        });

                // Bind JobApplicant to repository
        $this->app->bind(
            'Litecms\JobApplicant\Interfaces\JobApplicantRepositoryInterface',
            \Litecms\JobApplicant\Repositories\Eloquent\JobApplicantRepository::class
        );

        $this->app->register(\Litecms\JobApplicant\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\JobApplicant\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.job_applicant'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/job_applicant.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/job_applicant')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/job_applicant')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
