<?php

namespace Litecms\JobApplicant\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class JobApplicantTransformer extends TransformerAbstract
{
    public function transform(\Litecms\JobApplicant\Models\JobApplicant $job_applicant)
    {
        return [
            'id'                => $job_applicant->getRouteKey(),
            'key'               => [
                'public'    => $job_applicant->getPublicKey(),
                'route'     => $job_applicant->getRouteKey(),
            ], 
            'job_id'            => $job_applicant->job_id,
            'user_id'           => $job_applicant->user_id,
            'type'              => $job_applicant->type,
            'comment '          => $job_applicant->comment ,
            'status'            => $job_applicant->status,
            'url'               => [
                'public'    => trans_url('job_applicant/'.$job_applicant->getPublicKey()),
                'user'      => guard_url('job_applicant/job_applicant/'.$job_applicant->getRouteKey()),
            ], 
            'status'            => trans('app.'.$job_applicant->status),
            'created_at'        => format_date($job_applicant->created_at),
            'updated_at'        => format_date($job_applicant->updated_at),
        ];
    }
}